﻿var a4SessionCountDown = function () {
    var _buttons = null;
    var _countDownInMinutes = null;
    var _expirationDate = null;
    var _isCountdownStarted = false;
    var _isMouseOrKeyboardActive = false;
    var _neverExpire = false;
    var _popupRessources = null;
    var _sessionExpiredTimer = null;
    var _sessionLogoffTimer = null;
    var _timeoutVerificationInterval = null;
    var _pagesToKeepAlive = [
        "Project/Data/ApplyRecode",
        "Project/Data/OpenEndCoding",
        "Project/Data/AddCodeToQuestion"];

    init = function (document) {
        registerUserInteractionEvent(document);

        for (var i = 0; i < _pagesToKeepAlive.length; i++) {
            if (window.location.href.indexOf(_pagesToKeepAlive[i]) >= 0) {
                _neverExpire = true;
                break;
            }
        }

        a4.callServerMethod(a4.getAction("GetTimeOutConfiguration", "Shared", "Home"), {},
            function (result) {
                _countDownInMinutes = result.countDown;
                _timeoutVerificationInterval = result.verificationInterval * 60 * 1000;
                _popupRessources = result.popupRessources;
                _expirationDate = result.expiresOn;
                _buttons = [{
                    Text: _popupRessources.button,
                    CssClass: "primary h-resumeButton",
                    Action: function () {
                        keepAlive();
                        clearInterval(_sessionLogoffTimer);
                    }
                },
                {
                    Text: _popupRessources.logoOut,
                    CssClass: "secondary",
                    Action: function () {
                        clearInterval(_sessionExpiredTimer);
                        logoff("");
                    }
                }],

                startSessionTimeOutTimer();
            },
            function () {
                //On error do not start the timer.
                //The login page should enter this function.
            }
        );
    }

    registerUserInteractionEvent = function (document) {
        //These events are used to detect user interactions that do not send requests to the server.
        //This is why the resume button click never sets _isMouseOrKeyboardActive to true.

        $(document).on("click", function (e) {
            _isMouseOrKeyboardActive = !$(e.target).hasClass('h-resumeButton');
        });
        $(document).on("keydown", function (e) {
            _isMouseOrKeyboardActive = !$(e.target).hasClass('h-resumeButton');
        });
    }

    keepAlive = function () {
        a4.callServerMethod(a4.getAction("SessionKeepAlive", "Shared", "Home"), {},
            function (result) {
                _expirationDate = result.expiresOn;
            }
        );
    }

    isSessionExpiring = function () {
        var timestamp = new Date();
        var inverseOffset = moment(timestamp).utcOffset() * -1;
        var utcNow = moment().utcOffset(inverseOffset);
        var expiration = moment.utc(_expirationDate);
        return moment(utcNow).isAfter(expiration);
    }

    startSessionTimeOutTimer = function () {
        _sessionExpiredTimer = setInterval(function () {
            if (isSessionExpiring() && !_isCountdownStarted) {
                if (_neverExpire || (_isMouseOrKeyboardActive)) {
                    _isMouseOrKeyboardActive = false;
                    keepAlive();
                }
                else {
                    //This must be executed on the top most context since pop-ups can be nested.
                    //All popups must be closed before opening the warning.
                    a4.top().a4.sessionCountDown.closeDialogs();
                    a4.top().a4.sessionCountDown.startCountDownTimer();
                }
            }

        }, _timeoutVerificationInterval);
    }

    closeDialogs = function () {
        $.fancybox.close();
        $('.modernEditor').remove();
    }

    getCountDownString = function (timeRemaining) {
        var minutes = Math.floor((timeRemaining % (1000 * 60 * 60)) / (1000 * 60));
        var seconds = Math.floor((timeRemaining % (1000 * 60)) / 1000);
        var minutesAndSeconds = minutes + 'm' + seconds + 's';
        return _popupRessources.detail.replace('{0}', minutesAndSeconds);
    }

    startCountDownTimer = function () {
        clearInterval(_sessionExpiredTimer);
        modalDialog.showCustomDialog(
            getCountDownString(_countDownInMinutes * 1000 * 60),
            _popupRessources.title,
            _buttons,
            200, 400);

        var milisecondsRemaining = _countDownInMinutes * 1000 * 60;

        _sessionLogoffTimer = setInterval(function () {
            if (milisecondsRemaining <= 0) {
                closeDialogs();
                clearInterval(_sessionLogoffTimer);
                logoff(window.location.pathname);
            }
            else {
                $('.fancybox-opened').find('.wrapper').first().html(getCountDownString(milisecondsRemaining));
                milisecondsRemaining -= 1000;
            }
        }, 1000);
    }

    logoff = function (redirectURL) {
        var appMode = $("#HasCommandCenter").val() == "True" ? "MultiMode" : "Account";
        a4.top().window.location = a4.getAction("LogOff", appMode, null, { onErrorRedirectURL: redirectURL });
    }

    return {
        init: init,
        closeDialogs: closeDialogs,
        startCountDownTimer: startCountDownTimer
    };
}